CREATE DATABASE IF NOT EXISTS user_management;
USE user_management;

CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    email VARCHAR(100) NOT NULL UNIQUE,
    user_type ENUM('frontend', 'backend') NOT NULL,
    created_at DATETIME NOT NULL,
    reset_token VARCHAR(100) DEFAULT NULL,
    reset_token_expiry DATETIME DEFAULT NULL
);

CREATE TABLE IF NOT EXISTS password_reset_attempts (
    id INT AUTO_INCREMENT PRIMARY KEY,
    email VARCHAR(100) NOT NULL,
    ip_address VARCHAR(45) NOT NULL,
    attempt_time DATETIME NOT NULL,
    INDEX (email, attempt_time),
    INDEX (ip_address, attempt_time)
);

CREATE TABLE IF NOT EXISTS security_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    event_type VARCHAR(50) NOT NULL,
    user_id INT DEFAULT NULL,
    ip_address VARCHAR(45) NOT NULL,
    event_time DATETIME NOT NULL,
    additional_info TEXT,
    INDEX (event_type, event_time),
    INDEX (user_id),
    INDEX (ip_address),
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL
);

-- Insert test users
-- Admin user: admin@example.com / Admin@123!
-- Regular user: user@example.com / User@123!
INSERT INTO users (username, email, password, user_type, created_at, reset_token, reset_token_expiry) VALUES
('admin', 'admin@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'backend', NOW(), NULL, NULL),
('testuser', 'user@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'frontend', NOW(), NULL, NULL);

-- Add password history for test users
INSERT INTO password_reset_attempts (email, ip_address, attempt_time) VALUES
('admin@example.com', '127.0.0.1', NOW()),
('user@example.com', '127.0.0.1', NOW()); 