<?php
session_start();
require_once 'classes/User.php';
require_once 'classes/Security.php';

$security = new Security();

if(isset($_POST['reset_request'])) {
    // CSRF Protection
    if(!$security->validateCSRFToken($_POST['csrf_token'])) {
        $error = "Invalid request. Please try again.";
    } else {
        $email = $_POST['email'];
        $ip_address = $_SERVER['REMOTE_ADDR'];
        
        // Check both email and IP-based rate limiting
        if(!$security->checkRateLimit($email)) {
            $error = "Too many password reset attempts for this email. Please try again later.";
        } elseif(!$security->checkIPRateLimit($ip_address)) {
            $error = "Too many password reset attempts from your IP address. Please try again later.";
        } else {
            $user = new User();
            $result = $user->requestPasswordReset($email);
            
            if($result['success']) {
                $reset_link = "http://" . $_SERVER['HTTP_HOST'] . 
                             dirname($_SERVER['PHP_SELF']) . 
                             "/reset_password.php?token=" . $result['token'];
                
                // Send email
                if($security->sendPasswordResetEmail($email, $reset_link)) {
                    $_SESSION['success'] = "Password reset instructions have been sent to your email address.";
                } else {
                    // For testing purposes, show the link
                    $_SESSION['success'] = "Password reset link has been generated. In a real application, this would be sent to your email.<br>For testing: <a href='$reset_link'>Click here to reset your password</a>";
                }
            } else {
                $error = "No account found with that email address.";
            }
        }
    }
}

$csrf_token = $security->generateCSRFToken();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="text-center">Forgot Password</h3>
                    </div>
                    <div class="card-body">
                        <?php if(isset($_SESSION['success'])): ?>
                            <div class="alert alert-success">
                                <?php 
                                echo $_SESSION['success'];
                                unset($_SESSION['success']);
                                ?>
                            </div>
                        <?php endif; ?>

                        <?php if(isset($error)): ?>
                            <div class="alert alert-danger"><?php echo $error; ?></div>
                        <?php endif; ?>
                        
                        <form method="POST">
                            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                            <div class="mb-3">
                                <label for="email" class="form-label">Email Address</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>
                            <div class="d-grid">
                                <button type="submit" name="reset_request" class="btn btn-primary">Request Password Reset</button>
                            </div>
                        </form>
                        <div class="text-center mt-3">
                            <a href="login.php">Back to Login</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html> 